//---------------------------------------------------------------------------
// This file provides a template for using the Fpu library to connect
// the uM-FPU V3.1 floating point coprocessor to the Arduino platform.
// It shows the program setup, initial FPU reset sequence, and prints
// the version number of the FPU on the serial monitor. For a program
// that doesn't require the serial monitor, the Serial and FpuSerial
// function calls can be removed.
//
// By default, the chip select for the FPU is pin 10 (SS)
// To select a different pin, use Fpu.begin(pin).
//
// @version
//  October 2, 2011
//  - updated for new SPI and FpuSerial libraries
//  December 15, 2008
//  - original version
//---------------------------------------------------------------------------

#include <SPI.h>
#include <Fpu.h>
#include <FpuSerial.h>

//-------------------- local prototypes ---------------------------------------

//-------------------- uM-FPU register definitions --------------------------

//-------------------- setup ------------------------------------------------

void setup()
{
  Serial.begin(9600);
  Serial.println("Sample");
  
  SPI.begin();
  Fpu.begin();

  // Check for synchronization and display FPU version
  // (note: this is optional code)
  if (Fpu.sync() == SYNC_CHAR)
    FpuSerial.printVersionln();
  else
  {
    Serial.print("uM-FPU not detected");
    while(1) ; // stop if FPU not detected
  }
}

//-------------------- loop -------------------------------------------------

void loop()
{
  //  Insert main application code here.
  //  FPU instructions are sent using Fpu.write functions.
  //  e.g.
  //    Fpu.write(SELECTA, 1, LOADPI, FSET0);


  // Remove the following instructions for a continuous control loop.
  Serial.println("\r\nDone.");
  while(1) ;
}

